package com.ejie.p06b.x43.handler;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.w3c.dom.Document;

import com.ejie.p06b.n38.invoke.SecurityHelperXLNets;
import com.ejie.p06b.util.P06BParametros;


/**
 * 
 * @author GLOPEZRI
 * 
 */
public class HeaderHandler implements SOAPHandler<SOAPMessageContext> {

	private TransformerFactory transformerFactory;

	/**
	 * Constructor por defecto
	 */
	public HeaderHandler() {
		this.transformerFactory = TransformerFactory.newInstance();
	}

	/**
	 * Mtodo que aade la informacin del token XLNet en una peticin a
	 * servicio web
	 * 
	 * @param smc
	 *            Objeto de tipo SOAPMessageContext con el mensaje SOAP de la
	 *            peticin
	 * 
	 * @return Devuelve el estado de la peticin, true si todo ha ido bien,
	 *         false si ha existido algn problema
	 */
	public boolean handleMessage(SOAPMessageContext smc) {

		Boolean outboundProperty = (Boolean) smc
				.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);
		//String idApp = R76bMng.getProperties().getProperty("COD_APLIC");
		String idApp = P06BParametros.get("idApp");
		
		if (outboundProperty != null && outboundProperty.booleanValue()) {

			try {
				// Obtiene el token de XLNet
				Document token = SecurityHelperXLNets.getTokenXLNets(idApp);

				// Recupera cabecera SOAP
				SOAPHeader soapHeader = smc.getMessage().getSOAPHeader();

				// Incluye token en la cabecera creada
				Source source = new DOMSource(token);
				Result result = new DOMResult(soapHeader);
				this.transformerFactory.newTransformer().transform(source,
						result);

			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}

		return outboundProperty;

	}

	/**
	 * Mtodo que define las cabeceras de la peticin
	 * 
	 * @return Devuelve un objeto de tipo Set con las cabeceras de la peticin
	 */
	public Set getHeaders() {
		return new HashSet<QName>();
	}

	/**
	 * Mtod que implementa la interface de la clase
	 * javax.xml.ws.handler.Handler
	 * <javax.xml.ws.handler.soap.SOAPMessageContext>
	 * 
	 * @param context
	 *            Objeto de tipo SOAPMessageContext con el mensaje SOAP de la
	 *            peticin
	 * 
	 * @return Devuelve siempre true
	 */
	public boolean handleFault(SOAPMessageContext context) {
		return true;
	}

	/**
	 * Mtod que implementa la interface de la clase interface
	 * javax.xml.ws.handler
	 * .Handler<javax.xml.ws.handler.soap.SOAPMessageContext>
	 * 
	 * @param context
	 *            Objeto de tipo MessageContext con el mensaje SOAP de la
	 *            peticin *
	 */
	public void close(MessageContext context) {
		// Nada que hacer
	}
}